﻿var page = {};

const hasOpenUrl = (url) => {
  const tabList = page.tabs;
  let hasOpen = false;

  for (const tabId in tabList) {
    const tab = tabList[tabId];
    tab.url.includes("sucai.wangpu.taobao.com") && (hasOpen = true);
  }

  return hasOpen;
};

const checkForValidUrl = (tabId, changeInfo, tab) => {
  const url = tab.url;
  url.match("wangpu.taobao.com")
    ? ((page.type = "tb"), (page.tabId = tabId))
    : url.match("siteadmin.taobao.com") || url.match("siteadmin.tmall.com")
    ? ((page.type = "tb"), (page.tabId = tabId))
    : (page.type = "n");
};
chrome.tabs.onUpdated.addListener(checkForValidUrl);

page.tabs = {};

const tabCreated = (tab) => {
  page.tabs[tab.id] = tab;
  // console.log("tabCreated ", page.tabs);
};

const tabUpdated = (tabId, changeInfo, tab) => {
  // tab 更改时触发4次 changeInfo: loading -> favIconUrl -> title -> complete(即使没有聚焦,也会触发)
  page.tabs[tabId] = tab;
  // console.log("tabUpdated ", tabId, changeInfo, tab, page.tabs);

  // 每次淘宝页面更改后刷新cookies
  if (
    changeInfo &&
    changeInfo.status === "complete" &&
    tab.url.includes("taobao.com")
  ) {
    asyncGetTbCookies();
  }
};

const tabRemoved = (tabId, removeInfo) => {
  delete page.tabs[tabId];
  // console.log("tabRemoved ", page.tabs);
};

chrome.tabs.onCreated.addListener(tabCreated); // 新建标签 可能为空标签
// chrome.tabs.onDetached.addListener(tabDetached); // 标签从窗口脱离
chrome.tabs.onUpdated.addListener(tabUpdated); // 标签更改, 可能是空标签加载url 也可能是url改变
// chrome.tabs.onActivated.addListener(tabActivated); // 标签聚焦, 新建标签时也会聚焦该标签
chrome.tabs.onRemoved.addListener(tabRemoved); // 删除标签

// cookies
// page.cookies = [];
// const asyncGetAllCookies = () => {
//   chrome.cookies.getAll({}, (res) => (page.cookies = res));
// };
// asyncGetAllCookies();

// 初始时获取淘宝域下所有cookies 且淘宝页面更新后同时更新cookies
page.tbCookies = [];
const asyncGetTbCookies = () => {
  chrome.cookies.getAll(
    {
      domain: ".taobao.com",
    },
    (cookies) => {
      page.tbCookies = cookies;
    }
  );
};
asyncGetTbCookies();

// 同步获取保存的淘宝cookies
const getTbCookies = (name) => {
  const cookie = page.tbCookies.find((cookie) => cookie.name === name);
  return cookie && cookie.value;
};

function execFunc(func) {
  chrome.tabs.executeScript(page.tabId, {
    code: func,
  });
}

chrome.runtime.onConnect.addListener(function (port) {
  if (port.name == "tbapp") {
    port.onMessage.addListener(function (msg) {
      const {
        question,
        token: { type, Do },
      } = msg;
      console.log(port.sender.tab.title, " ----> background", msg);

      // 淘宝页面 ===> weex 工具页面
      if (question == "_tb_data_") {
        var tbopen = false;
        chrome.tabs.query({ active: true, currentWindow: true }, function (
          tabs
        ) {
          if (!tbopen) {
            var question = {
              question: "_tb_data_",
              data: msg.data,
              token: msg.token,
            };
            console.log(" background ---> ", tabs[0].title, msg);
            setConnect(tabs[0].id, question);
            tbopen = true;
          }
        });
      }

      // weex 工具页面 ===> 淘宝页面
      if (question == "_open_tb_page_") {
        var tbopen = false;
        var weexid = 0;
        chrome.tabs.query({}, function (tabs) {
          tabs.forEach(function (v, i) {
            if (v.url.indexOf("/weex/") > 0) {
              weexid = v.id;
            }
            if (type === "video" && Do === "list") {
              if (
                v.url.indexOf("ugc.taobao.com/sucai/ajax/videoQuery1.do") >=
                  0 &&
                !tbopen
              ) {
                // 请求视频数据
                tbopen = true;
                console.log(" background tbapp ---> ", v.title, msg);
                setConnect(v.id, {
                  question: "_open_tb_ok_",
                  token: msg.token,
                });
                return;
              } else if (
                (v.url.indexOf(".taobao") > 0 || v.url.indexOf(".tmall") > 0) &&
                !tbopen
              ) {
                tbopen = true;
                console.log(" background tbapp ---> ", v.title, msg);
                setConnect(v.id, {
                  question: "_open_tb_ok_",
                  token: msg.token,
                });
                return;
              }
            } else {
              if (
                (v.url.indexOf("sucai.wangpu.taobao.com") > 0 ||
                  v.url.indexOf(".tmall") > 0) &&
                !tbopen
              ) {
                tbopen = true;
                console.log(" background ---> ", v.title, msg);
                setConnect(v.id, {
                  question: "_open_tb_ok_",
                  token: msg.token,
                });
                return false;
              }
            }
          });
          if (!tbopen) {
            weexid || (weexid = tabs[0].id);
            console.log(" background tbapp ---> ", tabs[0].title, msg);
            setConnect(weexid, { question: "_open_tb_not_", token: msg.token });
          }
        });
      }
    });
  }
});

function setConnect(id, question) {
  var question = question || { question: "_open_tb_ok_" };
  var port = chrome.tabs.connect(id, { name: "tbapp" });
  question.id = Math.floor(Math.random() * 10000000000);
  port.postMessage(question);
}

const getBlobByBase64 = (base64) => {
  const fileType = base64.split(",")[0].split(":")[1].split(";")[0]; // exp: "image/jpeg"
  const base64Str = atob(base64.split(",")[1]);
  const buffer = new ArrayBuffer(base64Str.length);
  const unitArray = new Uint8Array(buffer);

  for (let index = 0; index < base64Str.length; index++) {
    unitArray[index] = base64Str.charCodeAt(index);
  }

  return new Blob([buffer], { type: fileType });
};

const uploadBlobImage = (blob, fileName, url, callback) => {
  const request = new XMLHttpRequest();
  const form = new FormData();
  form.append("file", blob, fileName);
  request.onreadystatechange = function () {
    if (typeof callback !== "function") {
      return;
    }
    if(request.readyState !== 4 && request.status !== 200) {
      return;
    }

    if (request.response) {
      callback(request.response);
    } else {
      callback(null);
    }
  };
  request.open("post", url, false);
  request.send(form);
};

// 由于跨域限制, 改为在 background 中发送请求, 通过 message 与页面传输
// ! sendResponse 必须同步执行 否则会报错: Unchecked runtime.lastError: The message port closed before a response was received.
const onMessage = (request, sender, sendResponse) => {
  // frameId: 0
  // id: "ndnfclnnhoeafjidbkiioiehhmpjoefe" 插件id
  // origin: "https://sucai.wangpu.taobao.com"
  // tab: {active, audible, autoDiscardable, discarded, favIconUrl, …} 发送消息的tab
  if (request.to !== "background") {
    return;
  }

  const { action, data: actionData } = request;

  switch (action) {
    case "ajax": {
      const { type, url, data } = actionData;
      $.ajax({
        async: false, // 必须为同步请求
        type: type.toLocaleUpperCase(),
        url,
        data,
        success(res) {
          sendResponse(res);
        },
        error(err) {
          sendResponse(res);
          console.log("err ", err)
        },
      });
      break;
    }
    // 验证是否已经打开特定几个页面
    case "open": {
      // urls 待验证的连接数组
      // validate 验证条件, && 所有链接都通过 || 有一条链接通过即可
      const { urls, validate } = actionData;
      if (validate === "&&") {
        sendResponse(urls.every(hasOpenUrl));
      }
      if (validate === "||") {
        sendResponse(urls.some(hasOpenUrl));
      }
      break;
    }
    // 获取指定cookies
    case "cookies": {
      const { domain, name } = actionData;
      if (domain.includes("taobao.com")) {
        sendResponse(getTbCookies(name));
      } else {
        // todo send other cookies
        sendResponse("no cookies");
      }
      break;
    }
    case "uploadBase64Image": {
      const { base64, fileName, url } = actionData;
      const blob = getBlobByBase64(base64);
      uploadBlobImage(blob, fileName, url, sendResponse);
    }
    default: {
      sendResponse(null);
      break;
    }
  }
};

chrome.runtime.onMessage.addListener(onMessage);
