/**
 * 扩展的WX页面JS
 * 处理一下页面加载的一些自动程序
 */
$(function () {
  // return false;
  /**
   *
   * 提示工具
   * msg，信息
   * obj,对象
   * json，参数
   *
   */
  var layer = {
    timeout: null,
    tips: function (msg, obj, json, callback) {
      $(".MTips").remove();
      this.timeout && clearTimeout(this.timeout);
      var t =
        "<div class='MTips' style='position: absolute;z-index:999999992;'><span style='padding:8px 15px;display:inline-block;width: 100%; text-align: center;color:#fff;border-radius: 3px;-moz-box-shadow:2px 2px 4px rgba(0,0,0,0.1);box-shadow:2px 2px 4px rgba(0,0,0,0.1)' class='tmsg'>" +
        msg +
        "</span><i style='display: block; overflow: hidden; width: 0px; height: 8px; border-left: 8px solid rgba(255, 255, 255, 0);margin-left:10px;'></i></div>";
      var y = obj.offset().top,
        x = obj.offset().left,
        h = obj.height(),
        bc = json.tips[1] || "#49b04d",
        time = json.time || 2000;
      $("body").append(t);
      t = $(".MTips");
      this.timeout = setTimeout(function () {
        t.fadeOut(function () {
          $(this).remove();
        });
        if (callback && $.isFunction(callback)) {
          callback();
        }
      }, time);
      switch (json.tips[0]) {
        case 1:
          t.css({ top: y - h - 5 + "px", left: x + "px" }),
            t.find(".tmsg").css({ background: bc }),
            t.find("i").css({ "border-top": "8px solid " + bc }),
            t.find("i").show();
          break;
        case 5:
          t.css({
            position: "fixed",
            top: "0",
            left: "45%",
            right: "45%",
            margin: "auto",
          }),
            t.find(".tmsg").css({ background: bc, padding: "12px 20px" }),
            t.find("i").hide();
          break;
        case 6:
          t.css({
            position: "fixed",
            top: "0",
            bottom: "0",
            height: "60px",
            left: "40%",
            right: "40%",
            margin: "auto",
          }),
            t.find(".tmsg").css({ background: bc, padding: "12px 20px" }),
            t.find("i").hide();
          break;
      }
    },
    pop: function (msg, color, callback) {
      $(".MTips-pop").remove();
      var msg1 = msg[0] || "",
        msg2 = msg[1] || "",
        icon = msg[2] || false,
        color1 = color[1] || "#333",
        color2 = color[2] || "#999";
      var t = [
        '<div class="MTips-pop" style="display: block;position: fixed;z-index: 999999992;text-align: center;">',
        '<div class="text" style="width:450px;height:260px;position: fixed;z-index: 19;top: -20px;left: 0;bottom: 0;right: 0;margin: auto;background: #f8f8f8;border-radius: 5px;overflow: hidden;box-sizing: border-box;">',
        '<div style="padding: 45px 20px 20px;">',
        '<div class="icon"></div>',
        '<div class="title" style="color:' +
          color1 +
          ';font-size: 14px;line-height:38px;margin-top: 10px;">' +
          msg1 +
          "</div>",
        '<div class="title-info" style="color:' +
          color2 +
          '">' +
          msg2 +
          "</div>",
        "</div>",
        '<div class="submit" style="position:absolute;width:100%;line-height: 50px;bottom: 0px;border-top: 1px solid #eee;font-size: 15px;cursor: pointer;"><span class="popcancel" style="display: inline-block;width: 50%;">取消</span><span class="popok" style="display: inline-block;width: 50%;color: #3089DC;">确定</span></div>',
        "</div>",
        '<div class="MTips-popBG" style="width: 100%;height: 100%;position: fixed;z-index: 10;top: 0;left: 0;background: rgba(0,0,0,0.3);"></div>',
        "</div>",
      ].join("");
      $("body").append(t);
      t = $(".MTips-pop");
      t.find(".text").animate({ top: "0px" }, "fast"); //加载动画
      if (icon) {
        t.find(".icon").css({
          background: "url(" + icon + ") center center no-repeat",
          height: "60px",
        });
      } else {
        t.find(".text").css("height", "200px");
      }
      var cancel = t.find(".popcancel"),
        ok = t.find(".popok");
      t.find(".MTips-popBG").click(function () {
        t.fadeOut();
        t.find(".text").animate({ top: "-100px" }, "slow");
      });
      cancel.click(function () {
        t.find(".MTips-popBG").click();
      });
      if (callback && $.isFunction(callback)) {
        callback({ root: t, cancel: cancel, ok: ok });
      }
    },
  };

  /**
   *
   * 本地暂存程序
   * @param {*} key
   * @param {*} type
   * @param {*} code
   *
   */
  var _localStorage_ = function (key, type, code) {
    try {
      if (type == "get") {
        return localStorage.getItem(key);
      }
      if (type == "set") {
        localStorage.setItem(key, code);
      } //记录
      if (type == "del") {
        localStorage.removeItem(key);
      } //记录
    } catch (error) {
      console.info(error + "_localStorage_");
    }
  };

  /**
   * 页面的默认数据
   */
  var pageData = {
    data: {},
    get: function () {
      var a = document.createElement("script"),
        b;
      a.setAttribute("class", "wx_globalData");
      a.type = "text/javascript";
      a.innerHTML =
        "document.body.setAttribute('pageInfo',JSON.stringify(window.globalData||{}));";
      document.body.appendChild(a);
      b = decodeURIComponent(document.body.getAttribute("pageInfo"));
      document.body.removeAttribute("pageInfo");
      b = JSON.parse(b);
      this.data.shopId = b.shopId;
      this.data.pageId = b.pageId;
      this.data._tb_token_ = $.cookie("_tb_token_");
      $(".wx_globalData").remove();
    },
  };

  /**
   * 页面的一些自动程序
   */
  var papp = {};
  //复制页面
  papp.copyPage = function () {
    var leftdom = $(".site-left");
    var key = "_copy_page_mods";
    if (leftdom.length) {
      var d = [
        '<div class="copyPage_wx">',
        '<div class="cbut ck_copy">迁移官方模块</i></div>',
        '<div class="cbut pastes">',
        '<div class="ck_paste">粘贴官方模块<i class="next-icon next-icon-arrow-down next-icon-xxs next-icon-last"></i></div>',
        '<div class="cpoper">',
        '<div class="cp ck_copy_2">迁移官方模块</div>',
        '<div class="cp del_copy">清除</div>',
        "</div>",
        "</div>",
        "</div>",
        "<style>",
        ".copyPage_wx .cbut{position: relative; height: 100%; font-size: 12px;display: flex;align-items: center; color:#666; margin-left:10px; cursor:pointer;}",
        ".copyPage_wx .ck_copy:hover{color:#3089DC;}",
        ".copyPage_wx .ck_paste{background: #009fff;padding: 3px 10px;color: #ffffff;border-radius: 13px;}",
        ".copyPage_wx .ck_paste:hover{background: #2890ff;}",
        ".copyPage_wx .cbut i{margin-left: 5px;}",
        ".copyPage_wx .cpoper{min-width: 120px; height:0px; line-height: 40px; position: absolute; top: 59px; margin-left: -8px; padding: 0px 14px 0px 14px;overflow: hidden;transition: all 0.2s ease;box-shadow: 1px 1px 10px 0 rgba(0,0,0,.1); font-size: 12px;background: #fff;}",
        ".copyPage_wx .cp{cursor:pointer;}",
        ".copyPage_wx .cp:hover{color:#3089DC;}",
        ".copyPage_wx .pastes{margin-left: 5px; margin-top: -1px;}",
        ".copyPage_wx .pastes:hover .cpoper{height:90px; padding: 5px 15px 5px 15px;}",
        "</style>",
      ].join("");
      leftdom.after(d);
      ck();
    }
    /**
     * dom，加载完后的一些执行程序比如点击，选择性显示等
     */
    function ck() {
      /**
       * 判定应该显示复制还是粘贴
       */
      var c_code = _localStorage_(key, "get");
      if (c_code) {
        $(".copyPage_wx .ck_copy").hide();
        $(".copyPage_wx .ck_paste").show();
        $(".copyPage_wx .cpoper").show();
      } else {
        $(".copyPage_wx .ck_copy").show();
        $(".copyPage_wx .ck_paste").hide();
        $(".copyPage_wx .cpoper").hide();
      }
      /**
       * 点击事件
       * 复制页面
       */
      $(".copyPage_wx .ck_copy").unbind("click"),
        $(".copyPage_wx .ck_copy").click(function () {
          /*
           * 查询页面上的模块列表
           */
          layer.tips("正在复制页面中的模块...", $("body"), {
            tips: [6],
            time: 2000,
          });
          get_mods(function (t) {
            try {
              if (t) {
                if (t.data.moduleList.length) {
                  /**
                   * 只复制官方模块，这里必须要处理一下
                   */
                  let newarr = [];
                  for (const key in t.data.moduleList) {
                    if (t.data.moduleList.hasOwnProperty(key)) {
                      const element = t.data.moduleList[key];
                      if (element.assetsPackageName == "taobaowpmod") {
                        newarr.push(element);
                      }
                      // newarr.push(element);
                    }
                  }
                  if (newarr.length) {
                    t.data.moduleList = newarr;
                    _localStorage_(key, "set", JSON.stringify(t));
                    layer.tips("模块复制成功，去粘贴页面吧！", $("body"), {
                      tips: [6],
                      time: 2000,
                    });
                    $(".copyPage_wx .ck_copy").hide();
                    $(".copyPage_wx .ck_paste").show();
                    $(".copyPage_wx .cpoper").show();
                  } else {
                    layer.tips("亲，页面中没有添加官方模块阿！", $("body"), {
                      tips: [6, "rgba(0,0,0,0.5)"],
                      time: 2000,
                    });
                  }
                } else {
                  layer.tips("亲，页面中没有添加官方模块阿！", $("body"), {
                    tips: [6, "rgba(0,0,0,0.5)"],
                    time: 2000,
                  });
                }
              }
            } catch (error) {
              console.info(error);
            }
          });
        });
      /**
       * 粘贴页面
       */
      $(".copyPage_wx .ck_paste").unbind("click"),
        $(".copyPage_wx .ck_paste").click(function () {
          var code = _localStorage_(key, "get");
          if (code) {
            /**
             * 查询一下要粘贴的页面有没有不存在的第三方模块
             * 有的话会无法编辑，需要给出用户提示
             */
            get_mods(function (t) {
              try {
                if (t) {
                  layer.tips("亲，正在查询模块状态，请稍等...", $("body"), {
                    tips: [6, "rgba(0,0,0,0.5)"],
                    time: 1000,
                  });
                  $.get(
                    "https://wangpu.taobao.com/shopdecorate/ajax/getPageDesignRule.do?_input_charset=utf-8&path=index",
                    {
                      _tb_token_: pageData.data._tb_token_,
                      shopId: t.data.globalData.shopId,
                      pageId: t.data.globalData.pageId,
                    },
                    function (tt, ss) {
                      if (tt.isSuccess) {
                        var module_ = JSON.stringify(tt.data.moduleGroups);
                        var c_code = JSON.parse(code);
                        var data = c_code.data.moduleList;
                        var flag = true;
                        if (data.length) {
                          $.each(data, function (a, e) {
                            if (module_.indexOf(e.componentId) == -1) {
                              flag = false;
                              return false;
                            }
                          });
                        }
                        if (flag) {
                          if (t.data.moduleList.length) {
                            layer.pop(
                              [
                                "页面中已有模块，确定粘贴吗？",
                                "粘贴会将之前迁移的官方模块追加在此页面中!",
                              ],
                              [],
                              function (CKobj) {
                                CKobj.ok.click(function () {
                                  CKobj.cancel.click();
                                  add_mod(code, t);
                                });
                              }
                            );
                          } else {
                            add_mod(code, t);
                          }
                        } else {
                          layer.pop(
                            [
                              "亲，此页面缺少模块，粘贴后会无法正常编辑",
                              "请确保复制的页面和粘贴的页面模板相同，且模块相同哦！",
                            ],
                            [],
                            function (CKobj) {
                              CKobj.ok.click(function () {
                                CKobj.cancel.click();
                                add_mod(code, t);
                              });
                            }
                          );
                          setTimeout(() => {
                            $(".MTips-pop .popok").html("继续粘贴");
                          }, 10);
                        }
                      } else {
                        console.info("err");
                        console.info(tt);
                      }
                    }
                  );
                } else {
                  console.info("数据异常");
                }
              } catch (error) {
                console.info(error);
              }
            });
          }
        });
      /**
       * 二次复制
       */
      $(".copyPage_wx .ck_copy_2").unbind("click"),
        $(".copyPage_wx .ck_copy_2").click(function () {
          $(".copyPage_wx .ck_copy").click();
        });
      /**
       * 清除
       */
      $(".copyPage_wx .del_copy").unbind("click"),
        $(".copyPage_wx .del_copy").click(function () {
          _localStorage_(key, "del");
          $(".copyPage_wx .ck_copy").show();
          $(".copyPage_wx .ck_paste").hide();
          $(".copyPage_wx .cpoper").hide();
        });
    }
    /**
     * 获取页面已经添加的模块列表
     */
    function get_mods(callback) {
      $.get(
        "https://wangpu.taobao.com/shopdecorate/ajax/getModuleData.do?_input_charset=utf-8",
        {
          _tb_token: pageData.data._tb_token_,
          shopId: pageData.data.shopId,
          pageId: pageData.data.pageId,
          path: "index",
        },
        function (t, s) {
          try {
            if (t.isSuccess) {
              if (callback) {
                callback(t);
              }
            }
          } catch (e) {
            console.info(e);
          }
        }
      );
    }
    /**
     * 在页面中添加模块
     * data， 之前页面复制的模块数据
     * page，当前页面的一些信息
     * callback，回调
     */
    function add_mod(data, page, callback) {
      try {
        var data = JSON.parse(data);
        var pg = page.data.globalData;
        var index = page.data.moduleList.length || 0;
        var cpdata = data.data.moduleList;
        var cp = 0;
        var cpok = 0;
        if (cpdata.length) {
          setcp(cpdata[0], cpdata);
        }
        /**
         * 递归添加保存模块操作
         * @param {} data
         */
        function setcp(data, list) {
          if (!data) {
            if (cp == cpok) {
              layer.tips("所有模块已经复制成功！1秒后自动刷新", $("body"), {
                tips: [6],
                time: 2000,
              });
              setTimeout(function () {
                location.reload();
              }, 200);
            } else {
              layer.tips(
                "部分模块没有复制成功，可能无权添加，或模块只能添加一次",
                $("body"),
                { tips: [6, "#ea4017"], time: 5000 }
              );
              setTimeout(function () {
                location.reload();
              }, 5000);
            }
            return false;
          }
          var id = data.componentId;
          var name = data.moduleInstantsName;
          var moduleData = JSON.stringify(data.moduleData);
          /**
           * 添加模块
           */
          $.get(
            "https://wangpu.taobao.com/shopdecorate/ajax/ajax.do?_input_charset=utf-8&action=ModuleDecorateAction&event_submit_do_create=true",
            {
              _tb_token_: pageData.data._tb_token_,
              shopId: pg.shopId,
              pageId: pg.pageId,
              componentId: id,
              index: index,
            },
            function (t2, s2) {
              index++; //添加的模块顺序号
              try {
                if (t2.isSuccess) {
                  var widgetId = t2.data.widgetId;
                  var componentId = t2.data.componentId;
                  layer.tips(name + "，模块添加成功！", $("body"), {
                    tips: [6],
                  });
                  /*
                   * 保存模块数据
                   */
                  $.post(
                    "https://wangpu.taobao.com/shopdecorate/ajax/ajax.do?_input_charset=utf-8&_tb_token_=" +
                      pageData.data._tb_token_,
                    {
                      event_submit_do_save: true,
                      action: "ModuleDecorateAction",
                      shopId: pg.shopId,
                      pageId: pg.pageId,
                      componentId: componentId,
                      widgetId: widgetId,
                      moduleData: moduleData,
                    },
                    function (t, s) {
                      cp++;
                      try {
                        if (t.isSuccess) {
                          layer.tips(name + "，数据保存成功！", $("body"), {
                            tips: [6],
                          });
                          cpok++;
                        } else {
                          layer.tips(JSON.parse(t.message).message, $("body"), {
                            tips: [6, "#ea4017"],
                          });
                        }
                      } catch (e) {
                        console.info(e);
                      }
                      try {
                        setcp(list[cp], list);
                      } catch (error) {
                        setcp(false);
                      }
                    }
                  );
                } else {
                  //这里的异常，有些模块只能添加一次，或没有权限添加
                  cp++;
                  layer.tips(t2.message, $("body"), { tips: [6, "#ea4017"] });
                  try {
                    setcp(list[cp], list);
                  } catch (error) {
                    setcp(false);
                  }
                }
              } catch (e) {
                console.info(e);
              }
            }
          );
        }
      } catch (error) {
        console.info(error);
      }
    }
  };

  //获取页面上的一些必备数据
  pageData.get();

  //复制页面
  //此功能太强大，暂时不能上线
  papp.copyPage();
});
