/*
 * @Author: SUTIE
 * @Date: 2020-11-04 12:20:38
 * @LastEditTime: 2020-11-11 14:55:19
 * @Description: 注入页面内的js, 可使用页面变量和方法, 只在sucai.wangpu.taobao.com注入
 * @FilePath: \沃姆插件-淘宝天猫装修辅助插件\js\inject.js
 */

// 创建一个自定义事件, 用于 inject 和 content_script 通信
const customEvent = document.createEvent("Event");
customEvent.initEvent("myCustomEvent", true, true);

const send = (data) => {
  document.body.dispatchEvent(
    new CustomEvent("myCustomEvent", {
      bubbles: false,
      detail: { trigger: "inject", data },
    })
  );
};

// 接收到 content 的事件后:
// action, callbackUID, type, url, data(params), ...
const getMessage = ({ action, callbackUID, ...data }) => {
  if (!action) {
    return;
  }
  const { type, url, data: params } = data;
  $.ajax({
    type,
    url,
    data: params || "",
    crossDomain: true,
    success: function (e) {
      send({ action: action, callbackUID, success: true, data: e });
    },
    error: function (err) {
      send({ action: action, callbackUID, success: false, err });
    },
    dataType: "jsonp",
  });
};

document.body.addEventListener("myCustomEvent", (e) => {
  const { trigger, data } = e.detail;
  if (trigger === "inject") {
    return;
  }
  getMessage(data);
});
